%% TIIS.cls -- KSII TIIS class (pdflatex OK; no '@' in source)
\NeedsTeXFormat{LaTeX2e}
\ProvidesClass{TIIS}[2025/11/28 v3.1 KSII TIIS class (pdflatex, no-at)]

\LoadClass[11pt,oneside]{article}

% ---------- Engine & fonts ----------
\RequirePackage{iftex}
\RequirePackage[T1]{fontenc}
\RequirePackage[utf8]{inputenc}
\RequirePackage{newtxtext}
\RequirePackage[varg]{newtxmath}
\RequirePackage{tgheros}        % Arial-like
\newcommand{\TIISArial}{\fontfamily{qhv}\selectfont}
\newcommand{\TIISTahoma}{\fontfamily{qhv}\selectfont}

% ---------- Core packages ----------
\RequirePackage{graphicx}
\RequirePackage{xcolor}
\RequirePackage{booktabs,array}
\RequirePackage{enumitem}
\RequirePackage{siunitx}
\RequirePackage{caption}
\RequirePackage{titlesec}
\RequirePackage{setspace}
\RequirePackage{titling}
\setlength{\droptitle}{-1.2cm}
\RequirePackage{authblk}

\RequirePackage{geometry}

% ---------- Running headers (KSII) ----------
\RequirePackage{textcomp}
\RequirePackage[twoside]{fancyhdr}
\RequirePackage{etoolbox}

% ---------- Colors ----------
\definecolor{TIISPurple}{RGB}{153,0,255}
\definecolor{TIISBlue}{RGB}{0,0,180}
\definecolor{TIISPureBlue}{RGB}{0,0,255}
\definecolor{TIISBrown}{RGB}{102,51,0}

% ---------- Page layout ----------
\geometry{
  a4paper,
  left=3.5cm,
  right=3cm,
  top=4.75cm,
  bottom=3.15cm,
  headsep=1.05cm,
  footskip=0.45cm % makes DOI/ISSN baseline 2.7 cm from paper bottom
}

% ---------- Content width ----------
\newlength{\TIISContentWidth}
\setlength{\TIISContentWidth}{\textwidth}

% ---------- Metadata (can be overridden in main .tex via \renewcommand) ----------
\newcommand{\tiisvol}{X}
\newcommand{\tiisno}{X}
\newcommand{\tiisdate}{December 20XX}
\newcommand{\tiisrunningauthors}{Hong et al.}
\newcommand{\tiisrunningtitle}{paper title}
\newcommand{\TIISfirstpagefootnote}{%
This research was supported by a research grant from the IT R\&D program of MKE/IITA, the Korean government [2025-Y-001-04, Development of Next Generation Security Technology].}

\newcommand{\TIISdoi}{http://doi.org/10.3837/tiis.2025.0X.00X}
\newcommand{\TIISissn}{\textbf{ISSN : 1976-7277}}

% ---------- Header text ----------
\newcommand{\TIISJournalHeader}{%
  KSII TRANSACTIONS ON INTERNET AND INFORMATION SYSTEMS
  \space VOL.~\tiisvol, NO.~\tiisno, \tiisdate}
\newcommand{\TIISRightHeader}{\tiisrunningauthors: \tiisrunningtitle}
\newcommand{\TIISHeaderFont}{\rmfamily\fontsize{8}{8}\selectfont\color{black}}

% ---------- Global header/footer style ----------
\fancyhf{}
\fancyhead[CO]{% odd pages
  \TIISHeaderFont\makebox[\textwidth][s]{\MakeUppercase{\TIISJournalHeader}\hfill \thepage}}
\fancyhead[CE]{% even pages
  \TIISHeaderFont\makebox[\textwidth][s]{\thepage\hfill \TIISRightHeader}}

\renewcommand{\headrulewidth}{0pt}
\renewcommand{\footrulewidth}{0pt}

\pagestyle{fancy}

% ---------- First page header/footer ----------
\fancypagestyle{firstpage}{%
  \fancyhf{}

  % ----- First-page header (journal header + copyright + page number) -----
  \fancyhead[CO]{\TIISHeaderFont
    \makebox[\textwidth][s]{%
      \begin{minipage}[t]{\textwidth}
        \MakeUppercase{\TIISJournalHeader}\\
        Copyright \textcopyright\ 2025 KSII
      \end{minipage}\hfill \thepage}}
  \fancyhead[CE]{}
  \renewcommand{\headrulewidth}{0pt}

  % ----- DOI + ISSN: fixed at footer baseline (aligned with Word footer position) -----
  \fancyfoot[C]{%
    {\rmfamily\fontsize{8}{10}\selectfont
      \makebox[\textwidth][s]{\TIISdoi\hfill \TIISissn}%
    }%
  }
}

% ---------- First-page brown rule + grant text ----------
% This block is placed just above the bottom text boundary.
\newcommand{\TIISfirstpagegrant}{%
  \vspace*{\fill}% push down to the bottom of the text area
  {%
    \parindent=0pt% no paragraph indentation inside this block
    \noindent{\color{TIISBrown}\rule{\textwidth}{0.8pt}}\par
    \vspace{2pt}%
    \noindent
    {\rmfamily\fontsize{9}{11}\selectfont
      \TIISfirstpagefootnote\par}%
  }%
}

% ---------- Clear footer for non-first pages ----------
\fancyfoot{}
\renewcommand{\footrulewidth}{0pt}

% ---------- Header height ----------
% Two lines of 8pt header text → headheight should be at least ~20 pt.
\setlength{\headheight}{20pt}

% ---------- Apply first-page style to \maketitle ----------
\AtBeginDocument{\apptocmd{\maketitle}{\thispagestyle{firstpage}}{}{}}

% ---------- Paragraph defaults ----------
\linespread{1.0}
\setlength{\parskip}{0pt}
\setlength{\parindent}{2em}

% After sectioning, restore normal body text (Times 11/13, left aligned)
\newcommand{\TIISafterheading}{%
  \par\normalfont\normalcolor\rmfamily\fontsize{11}{13}\selectfont
  \leftskip=0pt \rightskip=0pt \parfillskip=0pt plus 1fil
  \parindent=2em
}

% ---------- Section / subsection headings ----------
\titleformat{\section}[block]
  {\TIISArial\bfseries\color{TIISPurple}\fontsize{12}{14}\selectfont\centering}
  {\thesection.}{0.75em}{}[\TIISafterheading]

\titleformat{\subsection}[block]
  {\TIISArial\bfseries\color{black}\fontsize{11}{13}\selectfont}
  {\thesubsection}{0.75em}{}[\TIISafterheading]
\titlespacing*{\subsection}{0pt}{0.8\baselineskip}{0.3\baselineskip}

\titleformat{\subsubsection}[block]
  {\TIISArial\bfseries\color{black}\fontsize{11}{13}\selectfont}
  {\thesubsubsection}{0.75em}{}[\TIISafterheading]
\titlespacing*{\subsubsection}{0pt}{0.7\baselineskip}{0.25\baselineskip}

% ---------- Caption styles ----------
\DeclareCaptionLabelFormat{TIISfig}{Fig.\ #2.}
\DeclareCaptionLabelFormat{TIIStab}{Table\ #2.}
\DeclareCaptionLabelSeparator{twospaces}{\space\space}

\captionsetup[figure]{
  labelformat=TIISfig,
  labelsep=twospaces,
  justification=centering,
  font={footnotesize},
  labelfont={bf,color=TIISPureBlue},
  textfont={color=black}
}

\captionsetup[table]{
  labelformat=TIIStab,
  labelsep=space,
  position=top,
  justification=centering,
  font={footnotesize},
  labelfont={bf,color=TIISPureBlue},
  textfont={color=black}
}

% ---------- Title block via titling ----------
\pretitle{%
  \par\centering
  \TIISTahoma\color{TIISPurple}\fontsize{22}{22}\selectfont
}
\posttitle{\par}

\preauthor{\vspace{0.6\baselineskip}\par\centering{\Authfont}}
\postauthor{\par\normalfont}

\predate{\vspace{0.3\baselineskip}\par\centering\Affilfont}
\postdate{\par\vspace{0.1\baselineskip}}

% ---------- Author / affiliation layout ----------
\renewcommand\Authfont{\rmfamily\bfseries\fontsize{10}{12}\selectfont}
\renewcommand\Affilfont{\normalfont\rmfamily\mdseries\fontsize{9}{11}\selectfont}
\renewcommand\Authsep{, }
\renewcommand\Authand{, and }
\renewcommand\Authands{, and }
\setlength{\affilsep}{0.3em}

% Compact helper macro: three-line affiliation block
\newcommand{\affilblock}[4][]{%
  \affil[#1]{#2\par #3\par #4}%
}

% ---------- Abstract & keywords ----------
% Full-width purple horizontal rule (1 pt)
\newcommand{\TIIShrule}{%
  \par\noindent{\color{TIISPurple}\rule{\linewidth}{1pt}}\par}

\newcommand{\TIISCenteredHeading}[1]{%
  {\centering\TIISArial\color{black}\bfseries\itshape\fontsize{12}{14}\selectfont #1\par}}

\renewenvironment{abstract}{%
  \par\TIIShrule\vspace{0.8\baselineskip}%
  \TIISCenteredHeading{Abstract}\vspace{0.4\baselineskip}%
  \begin{center}\begin{minipage}{\TIISContentWidth}\color{black}\rmfamily\fontsize{11}{13}\selectfont
}{\end{minipage}\end{center}%
  \vspace{0.1\baselineskip}\TIIShrule%
  \vspace{0.1\baselineskip}}

% Keywords line (centered block: label in Arial, text in Times)
\newcommand{\keywords}[1]{%
  \par
  \noindent
  \makebox[\textwidth][c]{%
    \begin{minipage}{\TIISContentWidth}
      {\TIISArial\color{black}\bfseries\itshape\fontsize{12}{14}\selectfont Keywords:\ }%
      {\rmfamily\color{black}\fontsize{11}{13}\selectfont #1}%
    \end{minipage}%
  }%
  \par\vspace{0pt}%
  % After keywords on the first page, push remaining space down and draw
  % the brown rule + grant acknowledgment just above the bottom text line.
  \TIISfirstpagegrant
}

% ---------- Article history line (Received / revised / accepted / published) ----------
\newcommand{\TIISarticledates}[1]{%
  \vspace{-1.5\baselineskip}%
  \begin{center}
    {\rmfamily\itshape\fontsize{9}{11}\selectfont #1}%
  \end{center}%
  \vspace{-0.8\baselineskip}%
}

% ---------- TIIS biography: photo on the left, text flows to the right ----------
\makeatletter
\renewenvironment{TIISbiography}[2][]{
  \par\vspace{0.5\baselineskip}
  \setlength{\intextsep}{1.5pt}
  \setlength{\columnsep}{7pt}% Gap photo-text
  \begin{wrapfigure}{l}{1.2in}
    \vspace{-2pt}
    \includegraphics[width=1.4in,height=1.375in,clip,keepaspectratio]{#1}
  \end{wrapfigure}
  \noindent\textbf{#2}
}{
  \par\vspace{0.5\baselineskip}
}
\makeatother


\endinput
